
=============================================================================

                   MONITEST.BAS, A Display Alignment Tool.
                   ---------------------------------------

  Overview:-
  ----------

                   MONITEST.BAS, (C)2010, B.Walker, G0LCU.

(Apologies for any typos or grammar errors as it has not been checked
at all.)

This entirely MikeBASIC program is a test tool to set up and align
all types of monitor displays. It generates many different signals
used to set up the geometry of CRT, (Cathode Ray Tube), type
monitors and current monitors too.

The code is FREE and issued as Public Domain for MikeOS 4.0x and
greater. It is as good as if not better than a hardware commercial
item for sale at around 200 UKP, at the time of writing 19-02-2010:-

       http://cpc.farnell.com/ozan/oz-t1500/teletest-pc/dp/IN00454

The main signals the program does are:-

1) Centre Cross.
2) Crosshatch.
3) Colour/Color Bars.
4) Grey/Gray Scales.
5) Black To White Purity, (four levels, black = sync pulses only).
6) Primay Colours/Colors Purity, (Red, Green and Blue).
7) Focus Dots.
8) Multiburst.
9) Chequerboard.

Plus four extra signals:-

10) Pulse And Bar.
11) Line And Block.
12) Astigmatism.
13) Moire Patterning.

Numbers 10), 11) and 12) are added mainly for ancient monochrome displays,
but are still good for old colour monitors with CVBS inputs, (Composite
Video), as well as dedicated video inputs.

Number 13) is NOT a true Moire test but is just OK as this is because
of the limitation of video TEXT MODE 3.

  MINIMUM Requirements:-
  ----------------------

1) Any working complete PC using an 80386 CPU or higher, (this is the bottom
   limit of MikeOS, not what is actually a possible minimum).
2) Any Video Card/Adaptor that is capable of video TEXT MODE 3.
3) At least 1MB RAM.
4) A video output socket, CVBS, CGA, EGA, VGA etc...
5) Any 'working' colour, (black and white too!), monitor to setup/test.
6) A means of booting into MikeOS; (Floppy Disk, USB Stick or CDROM).
7) MikeOS 4.0x.
8) Any necessary interconnecting video cables.

Tested on a(n) RM, (Research Machines), ancient `486 8MB RAM laptop,
this HP Pavilion Dual Core development notebook, and finally, a current
Philips Quad Core desktop; all using Floppy Disk access, using either a USB
Floppy Drive or dedicated internal Floppy Drive...

Enjoy finding simple solutions to often very difficult problems... :)

Bazza, G0LCU... :)

-----------------------------------------------------------------------------

  Technical Specifications:-
  --------------------------

  Test Signals...................  1) Black To White Levels.
  (Not in any particular order.).  2) Purity. Red, Green And Blue.
                                   3) Static Convergence.
                                   4) Dynamic Convergence.
                                   5) Focus Dots.
                                   6) Colour Bars.
                                   7) Stepped Grey Scale.
                                   8) Chequerboard Beam Limiter Check.
                                   9) Multiburst Frequence Response.
  Added Extra Test Signals....... 10) Vertical Sync' Check.
  (Probably not much use today.). 11) Horizontal Sync' Check.
                                  12) Astigmatism.
                                  13) Moire Check. See "Limitations:-" below.
  Outputs........................  Completely dependant on the VIDEO
                                   ADAPTOR in use.
  Output Levels..................  Completely dependant on the VIDEO
                                   ADAPTOR in use.
  External Inputs................  None at all.
  Line And Frame Frequencies.....  Completely dependant on the VIDEO MODE
                                   and ADAPTOR in use.
  Audio Facilities...............  None at all.
  Menu Driven....................  Yes, keyboard access only.
  Original Copyright.............  Original copyright, (C)2010, G0LCU.

  Limitations:-
  -------------

  1) All signals are generated using TEXT MODE 3. This WAS CGA in the early
     days but is now emulated from within much higher video resolutions.
  2) Modern FSDs, (Flat Screen Displays), will work fine but realistically
     only the colour bars, greyscale levels, purity, bright white burn-in
     and multiburst will be of any real use.
  3) BEWARE when using the bright white burn-in screen as this could cause
     damage to FSDs if used in a long term test!
  4) The "Moire Check", item 13) above, is a compromise due to the limits
     of TEXT MODE 3 so don't take this to seriously. The BASIC code is free
     so that you can change the character that best produces some sort of
     interference patterning for your personal usage.
  5) "Astigmatism", item 12) above is probably not much use as this is an
     ancient test for old Black And White CVBS monitors, but hey I'll bet
     most of you didn't know it existed... ;o)

-----------------------------------------------------------------------------

  Usage:-
  -------

On program startup there is a menu User Interface, (UI), with letters to
access the relevant test screen signals.

Each letter will start each respective test screen signal.

To exit each test screen just press either the 'Space Bar', OR, the
<RETURN/ENTER> key to return to the main UI.

The 'Esc' key will totally quit the program back to MikeOS.

That`s all there is to it...

Enjoy... :)

=============================================================================

                                 Test-Modes.
                                 -----------

  Black To White, (4 levels):-
  ----------------------------

  Press <RETURN/ENTER> to toggle through each screen.
  A) ALL BLACK.
   1) In CVBS mode gives a series of sync pulses at line and field
      frequencies along with a colour subcarrier, this can be used
      to give sync pulses 'only'.
   2) In RGB modes it provides the same as 1) above BUT without any
      colour subcarrier.

  B) DARK GREY, (with a BLACK border?).
   1) In CVBS mode lifts black level to above sync level for a
      test of EHT regulation, low level backround ~purity~ and PSU
      regulation, check on video DC linearity is possible. Also checks
      background colour settings and for flyback lines.
   2) In RGB modes same as 1) above.

  C) WHITE, (with a BLACK border?).
   1) Same as B), 1), EXCEPT for ~low level~ read ~medium level~.
   2) Same as B), 2).

  D) BRIGHT WHITE, (with a BLACK border?)...
   ALL the same as C), EXCEPT for ~medium level~ read ~high brightness~
   mode.
   Mainly for Flat Screen Monitors for primary check of dead pixels.
   Also used for ~burn in~ mode for FSMs, BEWARE do not use for long
   periods, (unless you know what you are doing), on FSMs as damage
   could result. Also used for EHT and PSU regulation in CRT type
   monitors.
   Also checks purity overall for all three guns on CRTs.

  Purity, (3 levels):-
  --------------------

  Press <RETURN/ENTER> to toggle through each screen.
   1) Red purity, used to set up mechanical positioning of scanning
      yoke and convergence coil assembly. Checks startup degaussing
      and for flyback lines.
   2) Green purity & 3) Blue purity, a backup check for 1)
      For flat screen monitors this is an initial check for dead
      pixels.

  All other tests just press the 'Space Bar' to toggle each screen.

  Colour Bars, (with BLACK border?):-
  -----------------------------------

   This is the primary check on aging CRTs, colour flaring, flyback
   lines on certain colours, EHT and PSU regulation. Also a check on
   colour burst phase and amplitude in CVBS modes.

  Grey Scales, (with BLACK border?):-
  -----------------------------------

   This is the primary check of video linearity using a stepped
   greyscale waveform, secondary checks are EHT regualtion,
   decoupling, video ringing and colour ~noise~ in CVBS modes.
   Also checks dynamic video DC conditions and stability.

  Centre Cross:-
  --------------

   Used to set up static conditions of gun assembly. The cross should
   be white on black, have NO colour fringes to it, should have NO
   ringing. This is the first check on video bandwidth and focussing.
   It gives a definate electronic position of centre so as to adjust
   any magnetic and/or DC conditions in the scanning yoke/convergence
   assembly.

  Crosshatch:-
  ------------

   NOT absolutely full screen due to TEXT MODE 3 characters.
   Used to set up dynamic conditions of gun assembly. A series of
   horizontal and vertical lines should be white on black, have NO
   colour fringes, have NO ringing, be linear in both planes, be in
   focus all over, have NO wavyness on the verticals and have NO
   overshoot on the horizontals. Secondary checks on video bandwidth.
   It is also used to set up ALL subtle linearity, pincushion, barrel
   and trapezoid controls for a good quality overall linearity.

  Checkerboard:-
  --------------

   This checks the ability for the sync CCTs to reject black and
   white blocks generated. Also this is the main test for dynamic
   EHT/PSU regulation at High MF speeds. Secondary checks on decoupling
   CCTs.

  Multiburst Frequency Response:-
  -------------------------------

   This is the standard Frequency Response test from Low MF to the
   highest possible for that video mode. Secondary checks on ringing
   and video bandwidth. Frequencies are arbitrary and depend entirely
   on the video mode in use.

  Focus Dots:-
  ------------

   The primary check for focussing. Secondary check for colour
   fringing.

  Pulse And Bar:-
  ---------------

   This is a check on the HF and MF ability of a monitor at line
   speed, checks for video overshoot, ringing and DC conditions.
   Also checks for line sync rejection of the pulse, decoupling
   CCTs and medium speed dynamic EHT/PSU regulation.

  Line And Block:-
  ----------------

   This is a check on the LF and Low MF ability of a monitor at
   field speed, checks for mains hum/injection into the field
   sync CCTs. Also checks for field sync rejection of the block,
   decoupling CCTs and low speed dynamic EHT/PSU regulation.

  Astigmatism:-
  -------------

   Added purely for B&W CVBS sets to check dynamic focussing of a
   single line white on black, secondary focus check for colour CVBS
   monitors.

  Moire Interference Gratings:-
  -----------------------------

   This is of limited use in this package but added for fullness.

============================================================================

  MONITEST.BAS, The BASIC Program:-
  ---------------------------------

Below is the code for the pattern generator. Before then is a brief
explanation of the code and what it does; therefore on starting the code...

It POKEs values into a memory area to create a simple machine code routine
that is able to print coloured ASCII characters to the screen. The code
then sets up only four variables and creates a simple UI, (User Interface),
containing simple keyboard commands to access all of the signals. The letters
to use each signal screen are NOT case sensitive so lower or upper case are
equally valid.

When in ANY signal screen, either the 'Space Bar', OR, the <ENTER/RETURN>
key will eventually get you back to the UI.

The 'Esc' key in the main UI will quit the program back to MikeOS...


REM MONITEST.BAS, a CRT monitor alignment tool.
REM (C)2010, B.Walker, G0LCU, issued as PD for MikeOS.


REM Enter the machine code subroutine for colour control...
POKE 156 65500
POKE 80 65501
POKE 83 65502
POKE 81 65503
POKE 184 65504
POKE 32 65505
POKE 9 65506
POKE 183 65507
POKE 0 65508
POKE 179 65509
POKE 7 65510
POKE 185 65511
POKE 1 65512
POKE 0 65513
POKE 205 65514
POKE 16 65515
POKE 89 65516
POKE 91 65517
POKE 88 65518
POKE 157 65519
POKE 195 65520


start:
REM Set all variables here.
c = 0
l = 0
k = 27
n = 1


REM Set up the main screen here.
CLS
CURSOR ON
MOVE 16 1
PRINT "Full pattern generator to test CRT type monitors."
MOVE 10 2
PRINT "(C)2010, B.Walker, G0LCU. Issued to MikeOS as Public Domain."
MOVE 30 4
PRINT "X) Centre Cross..."
MOVE 30 5
PRINT "H) Crosshatch....."
MOVE 30 6
PRINT "C) Colour Bars...."
MOVE 30 7
PRINT "G) Grey Scales...."
MOVE 30 8
PRINT "P) Purity........."
MOVE 30 9
PRINT "W) Black To White."
MOVE 30 10
PRINT "F) Focus Dots....."
MOVE 30 11
PRINT "B) Chequerboard..."
MOVE 30 12
PRINT "M) Multiburst....."
MOVE 29 14
PRINT "[U) Pulse_&_Bar....]"
MOVE 29 15
PRINT "[L) Line_&_Block...]"
MOVE 29 16
PRINT "[A) Astigmatism....]"
MOVE 29 17
PRINT "[I) Moire Patterns.]"
MOVE 30 19
PRINT "Esc) To Quit......"
MOVE 27 22
PRINT "Press the required key:- " ;


keyboardhold:
REM This is the holding routine...
GETKEY k
IF k = 88 THEN GOTO centrecross
IF k = 120 THEN GOTO centrecross
IF k = 72 THEN GOTO crosshatch
IF k = 104 THEN GOTO crosshatch
IF k = 67 THEN GOTO colourbar
IF k = 99 THEN GOTO colourbar
IF k = 65 THEN GOTO astigmatism
IF k = 97 THEN GOTO astigmatism
IF k = 71 THEN GOTO greyscale
IF k = 103 THEN GOTO greyscale
IF k = 73 THEN GOTO moire
IF k = 105 THEN GOTO moire
IF k = 76 THEN GOTO lineandblock
IF k = 108 THEN GOTO lineandblock
IF k = 85 THEN GOTO pulseandbar
IF k = 117 THEN GOTO pulseandbar
IF k = 80 THEN GOTO purity
IF k = 112 THEN GOTO purity
IF k = 87 THEN GOTO whitetoblack
IF k = 119 THEN GOTO whitetoblack
IF k = 77 THEN GOTO multiburst
IF k = 109 THEN GOTO multiburst
IF k = 66 THEN GOTO chequerboard
IF k = 98 THEN GOTO chequerboard
IF k = 70 THEN GOTO focus
IF k = 102 THEN GOTO focus
IF k = 27 THEN GOTO cleanexit
GOTO keyboardhold
REM End of keyboardhold loop.


cleanexit:
REM Clean exit to MikeOS.
CLS
END
REM End of program...


crosshatch:
REM The standard dynamic convergence crosshatch test.
CLS
REM Draw the horizontal lines.
n = 196
l = 0
lines:
FOR c = 1 TO 78
MOVE c l
PRINT CHR n ;
NEXT c
l = l + 3
IF l >= 24 THEN GOTO columnstart
GOTO lines
columnstart:
REM Draw the vertical lines.
n = 179
c = 0
columns:
FOR l = 1 TO 23
MOVE c l
PRINT CHR n ;
NEXT l
c = c + 8
IF c >= 78 THEN GOTO lastcolumn
GOTO columns
lastcolumn:
c = 79
FOR l = 1 TO 23
MOVE c l
PRINT CHR n ;
NEXT l
REM Draw the crossover points.
n = 197
c = 8
l = 3
crosses:
MOVE c l
PRINT CHR n ;
c = c + 8
IF c >= 73 THEN l = l + 3
IF c >= 73 THEN c = 8
IF l >= 22 THEN GOTO corners
GOTO crosses
corners:
REM Draw the corners.
n = 218
MOVE 0 0
PRINT CHR n ;
n = 191
MOVE 79 0
PRINT CHR n ;
n = 192
MOVE 0 24
PRINT CHR n ;
MOVE 79 24
POKE 7 65510
POKE 217 65505
CALL 65500
REM Draw all the `T` pieces to finalise the crosshatch.
n = 194
c = 8
top:
MOVE c 0
PRINT CHR n ;
c = c + 8
IF c >= 78 THEN GOTO bottomstart
GOTO top
bottomstart:
n = 193
c = 8
bottom:
MOVE c 24
PRINT CHR n ;
c = c + 8
IF c >= 78 THEN GOTO leftstart
GOTO bottom
leftstart:
n = 195
l = 3
left:
MOVE 0 l
PRINT CHR n ;
l = l + 3
IF l >= 23 THEN GOTO rightstart
GOTO left
rightstart:
n = 180
l = 3
right:
MOVE 79 l
PRINT CHR n ;
l = l + 3
IF l >= 23 THEN GOTO keyhold
GOTO right
REM End of crosshatch test.


moire:
REM Attempt, (badly), to generate moire patterning using CGA text mode.
REM This will NOT be successful on ALL machines.
CLS
REM Choose character from 176, 177 or 178...
n = 176
MOVE 0 1
FOR c = 0 TO 1839
PRINT CHR n ;
NEXT c
GOTO keyhold
REM Moire patterning end.


chequerboard:
REM Start of chequerboard subroutine.
CLS
REM Print 24 lines of alternate white and black blocks.
n = 219
FOR l = 0 TO 11
FOR c = 0 TO 19
PRINT CHR n ;
PRINT CHR n ;
PRINT "  " ;
NEXT c
FOR c = 0 TO 19
PRINT "  " ;
PRINT CHR n ;
PRINT CHR n ;
NEXT c
NEXT l
REM Print the last line to the last but one pair of blocks.
FOR c = 0 TO 18
PRINT CHR n ;
PRINT CHR n ;
PRINT "  " ;
NEXT c
REM Now print the LAST white block.
PRINT CHR n ;
PRINT CHR n ;
GOTO keyhold
REM End of chequerboard routine.


pulseandbar:
REM The old pulse and bar test mainly for monochrome systems.
CLS
REM Generate left hand side pulse.
n = 179
FOR l = 0 TO 24
MOVE 0 l
PRINT CHR n ;
NEXT l
REM Generate the bar section per line.
n = 219
FOR l = 0 TO 23
FOR c = 40 TO 79
MOVE c l
PRINT CHR n ;
NEXT c
NEXT l
MOVE 40 24
FOR c = 40 TO 78
PRINT CHR n ;
NEXT c
MOVE 79 24
REM Finish the last character without generating a CR/NL.
POKE 7 65510
POKE 219 65505
CALL 65500
GOTO keyhold
REM End of pulse and bar routine.


lineandblock:
REM The old line and block test mainly for monochrome systems.
CLS
REM Generate the top line.
n = 196
FOR c = 0 TO 79
PRINT CHR n ;
NEXT c
REM Generate the half screen block.
MOVE 0 13
n = 219
FOR l = 0 TO 958
PRINT CHR n ;
NEXT l
MOVE 79 24
REM Finish the last character without generating a CR/NL.
POKE 7 65510
POKE 219 65505
CALL 65500
GOTO keyhold
REM End of line and block routine.


multiburst:
REM Frequency response test, multiburst.
CLS
REM For each line printed........
FOR l = 1 TO 23
n = 219
REM Print LF frequency.
MOVE 0 l
FOR c = 1 TO 5
PRINT CHR n ;
PRINT CHR n ;
PRINT "  " ;
NEXT c
REM Print LF * 2 frequency.
MOVE 20 l
FOR c = 1 TO 10
PRINT CHR n ;
PRINT " " ;
NEXT c
REM Print LF * 4 frequency.
n = 221
MOVE 40 l
FOR c = 1 TO 20
PRINT CHR n ;
NEXT c
REM Print HF frequency.
n = 186
MOVE 60 l
FOR c = 1 TO 20
PRINT CHR n ;
NEXT c
REM Next line to be printed.
NEXT l
GOTO keyhold
REM Multiburst subroutine end.


centrecross:
REM Convergence centre cross generator.
REM Set colour to bright white on black.
CLS
POKE 15 65510
REM Do the vertical line first'
POKE 179 65505
MOVE 40 10
CALL 65500
MOVE 40 11
CALL 65500
MOVE 40 13
CALL 65500
MOVE 40 14
CALL 65500
REM Do the horizontal line second.
POKE 196 65505
FOR n = 35 TO 45
MOVE n 12
CALL 65500
NEXT n
REM Do the cross in the middle.
POKE 197 65505
MOVE 40 12
CALL 65500
GOTO keyhold
REM End of centre cross generator.


astigmatism:
REM A B&W test of a single white line across the screen.
CLS
REM Set the character and its start position.
n = 196
MOVE 0 12
REM Print the line white on black.
FOR c = 0 TO 79
PRINT CHR n ;
NEXT c
GOTO keyhold
REM Astigmatism test end.


focus:
REM Focus dot generator.
CLS
FOR c = 1 TO 38
FOR l = 0 TO 24
n = c * 2
MOVE n l
PRINT ". " ;
NEXT l
NEXT c
GOTO keyhold
REM End of focus dot routine.


whitetoblack:
REM The black to white full screen test.
REM Select the levels of full screens of grey
FOR n = 1 TO 4
CLS
IF n = 1 THEN POKE 0 65510
IF n = 2 THEN POKE 8 65510
IF n = 3 THEN POKE 7 65510
IF n = 4 THEN POKE 15 65510
REM The character to be printed.
POKE 219 65505
REM Clear the screen in each grey level.
FOR c = 0 TO 79
FOR l = 0 TO 24
MOVE c l
CALL 65500
NEXT l
NEXT c
MOVE 0 0
CURSOR OFF
whitetoblackkey:
REM Hold each screen.
GETKEY k
IF k = 13 THEN GOTO whitetoblackloop
GOTO whitetoblackkey
whitetoblackloop:
REM Next grey screen.
NEXT n
GOTO start
REM End of grey screen routine.


purity:
REM The three primary colours for purity tests.
REM Select the primary colours one at a time.
FOR n = 1 TO 3
CLS
IF n = 1 THEN POKE 4 65510
IF n = 2 THEN POKE 2 65510
IF n = 3 THEN POKE 1 65510
REM The character to be printed.
POKE 219 65505
REM Clear the screen in each primary colour.
FOR c = 0 TO 79
FOR l = 0 TO 24
MOVE c l
CALL 65500
NEXT l
NEXT c
MOVE 0 0 
CURSOR OFF
puritykey:
REM Hold each screen.
GETKEY k
IF k = 13 THEN GOTO purityloop
GOTO puritykey
purityloop:
REM Next purity screen.
NEXT n
GOTO start
REM End of purity routine...


colourbar:
REM Start of the colour bar generator.
REM Block character to be printed.
CLS
POKE 219 65505
FOR c = 0 TO 79
FOR l = 0 TO 24
REM Position to print a simple series of characters.
MOVE c l
REM This generates the colours for the colour bars.
IF c = 0 THEN POKE 15 65510
IF c = 10 THEN POKE 14 65510
IF c = 20 THEN POKE 3 65510
IF c = 30 THEN POKE 2 65510
IF c = 40 THEN POKE 5 65510
IF c = 50 THEN POKE 4 65510
IF c = 60 THEN POKE 1 65510
IF c = 70 THEN POKE 0 65510
CALL 65500
NEXT l
NEXT c
GOTO keyhold
REM End of colour bar routine...


greyscale:
REM Start of the greyscale generator.
REM Block character to be printed.
CLS
POKE 219 65505
FOR c = 0 TO 79
FOR l = 0 TO 24
REM Print position for the greyscale characters.
MOVE c l
REM This generates the greys for the greyscales.
IF c = 0 THEN POKE 0 65510
IF c = 20 THEN POKE 8 65510
IF c = 40 THEN POKE 7 65510
IF c = 60 THEN POKE 15 65510
CALL 65500
NEXT l
NEXT c
GOTO keyhold
REM End of greyscale routine.

keyhold:
REM Move the cursor to the top left hand corner and turn it off.
MOVE 0 0
CURSOR OFF
keyholdpause:
REM This holds any display using space bar to go to start...
GETKEY k
IF k = 32 THEN GOTO start
GOTO keyholdpause
REM End of keyhold routine.


REM This BASIC code is completely MikeOS 4.0x compatible.
REM It uses ONLY CGA text mode 3 graphics characters from BIOS.
REM Tested on RM, (Research Machines), ancient `486 laptop.
REM Also this HP Pavilion Dual Core notebook.
REM And finally a current Philips Quad Core desktop.
REM Code finish date:- 18-02-2010...

-----------------------------------------------------------------------------

  COLOUR.ASM, Coloured Text Subroutine:-
  --------------------------------------

This routine is assembled using the A86 assembler inside MS-DOS.

'COLOUR.COM' is the file generated and is in the acrhive as 'COLOUR.DAT'. The
text 'HEX' file created quickly from an AMIGA, (yes an AMIGA :), CLI/Shell;
see below as 'COLOUR.HEX'. This was converted to decimal values and these
values are POKEd into memory at the start of the BASIC code...

;COLOUR.ASM source code for the POKEd values in the BASIC program.
;(C)2010 B.Walker, G0LCU, issued as PD for MikeOS.
;Simple colour control on characters for MikeOS 4.0x and above.
;
;Assembled using AD86 combination inside an MS-DOS prompt.
;
;start:
	pushf			;Save used registers.
	push	ax		;
	push	bx		;
	push	cx		;
	mov	ax,0920h	;Set the character to SPACE for interrupt
				;using function ah = 09h...
	mov	bh,00h		;Set the page to be written to.
	mov	bl,07h		;Set to white on black.
	mov	cx,01h		;Just print one character unless changed.
	int	10h		;Trigger the interrupt.
	pop	cx		;Return registers back
	pop	bx		;
	pop	ax		;
	popf			;
	ret			;Return to the calling routine...
;end:
;End of subroutine...


  COLOUR.HEX, The Text 'Hexadecimal' Readout:-
  --------------------------------------------

Each 'HEX' value is converted to decimal and the correct offsets found to
generate a two coloured printable single ASCII character. Quickly obtained
from WinUAE and AMIGA OS 3.1x using a standard AMIGA command from the CLI.

0000: 9C505351 B82009B7 00B307B9 0100CD10    .PSQ ......
0010: 595B589D C3                            Y[X.

This routine, once POKEd into memory, is 21 bytes long.

=============================================================================

                                IMPORTANT:-
                                -----------

    The Legal Stuff:-
    -----------------

    These programs are Freeware and no profit will be made from them,
    also all of the files must remain unaltered and intact including this
    one. The author is not responsible for any damage to, or loss of, or
    failure of equipment or data caused in any way by the use of these
    programs. There is NO warranty with the use of these software releases
    and YOU USE THEM AT YOUR OWN RISK.

-----------------------------------------------------------------------------

                                 WARNING.
                                 --------

  1) DISCONNECT any faulty equipment under test from the MAINS supply.
  2) If a DC supply is used do NOT reverse polarity the connections.
  3) Do NOT power up any electronic item until it is safe to do so.
  4) CHECK and RECHECK all of your construction and repair work thoroughly.
  5) Handle ALL tools used with care.
  6) Beware of ALL types of solvents, glues and etching fluids.
  7) NEVER leave a soldering iron switched on unattended.
  8) KEEP everything OUT of the reach of small children.
  9) Switch OFF the computer before disconnecting or connecting any hardware.
 10) And finally read 1) to 9) again.

-----------------------------------------------------------------------------

   Contact:-
   ---------

   Mr Barry Walker, G0LCU,
   70 King George Road,
   Loughborough,
   Leicestershire,
   LE11 2PA,
   England.

   Email:-     wisecracker@tesco.net
   URL:-       http://homepages.tesco.net/wisecracker/G0LCU.HTM

   (Author of the ~TestGear?~ projects in the ~docs/hard~ drawer of AMINET.)

               http://aminet.net/search?readme=wisecracker

=============================================================================
